///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK ScheduleDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
	if(xMessage == WM_INITDIALOG) // Received an initilize dialog message
	{
		ScheduleDialog_hWnd = xHandle;

		SendMessage(ScheduleDialog_hWnd,(UINT)WM_SETTEXT,(WPARAM)0,(LPARAM)"Schedule Manager");
		SendMessage(ScheduleDialog_hWnd,WM_SETICON,TRUE,(LPARAM)LoadIcon(MainInstance,MAKEINTRESOURCE(100)));

		SD.ListView_hWnd = GetDlgItem(ScheduleDialog_hWnd, 1000);

        int LVStyle = LVS_EX_GRIDLINES | LVS_EX_FULLROWSELECT;
        SendMessage(SD.ListView_hWnd, (UINT)LVM_SETEXTENDEDLISTVIEWSTYLE, (WPARAM)0, (LPARAM)LVStyle);

        SD.LVColumb.cx        = 50;
        SD.LVColumb.pszText   = "ID";
        SD.LVColumb.iSubItem  = 0;
        SD.LVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        SD.LVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(SD.ListView_hWnd, 0, &SD.LVColumb);

        SD.LVColumb.cx        = 100;
        SD.LVColumb.pszText   = "Name";
        SD.LVColumb.iSubItem  = 1;
        SD.LVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        SD.LVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(SD.ListView_hWnd, 1, &SD.LVColumb);

        SD.LVColumb.cx        = 100;
        SD.LVColumb.pszText   = "Description";
        SD.LVColumb.iSubItem  = 2;
        SD.LVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        SD.LVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(SD.ListView_hWnd, 2, &SD.LVColumb);

        SD.LVColumb.cx        = 100;
        SD.LVColumb.pszText   = "Next Operation";
        SD.LVColumb.iSubItem  = 3;
        SD.LVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        SD.LVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(SD.ListView_hWnd, 3, &SD.LVColumb);

        SD.LVColumb.cx        = 100;
        SD.LVColumb.pszText   = "Database";
        SD.LVColumb.iSubItem  = 5;
        SD.LVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        SD.LVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(SD.ListView_hWnd, 4, &SD.LVColumb);

        SD.LVColumb.cx        = 200;
        SD.LVColumb.pszText   = "Filename";
        SD.LVColumb.iSubItem  = 5;
        SD.LVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        SD.LVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(SD.ListView_hWnd, 5, &SD.LVColumb);

        LoadScheduleIntoDialog();

		CenterWindow(ScheduleDialog_hWnd);

		return 0;
	}

	if(xMessage == WM_COMMAND) // Received A Message
	{
   		if(wParam == 102) // Add Item Button (Dialog Command)
   		{
            if(NumberOfSetSchedules >= MaxSchedules)
            {
                MessageBox(ScheduleDialog_hWnd, "The maximum scheduled items have been reached.", TitleCaption, 0);
                return 0;
            }

            DialogBox(MainInstance, MAKEINTRESOURCE(105), ScheduleDialog_hWnd, AddScheduleDialog);
			return 0;
   		}

   		if(wParam == 103) // Edit Item Button (Dialog Command)
   		{
            int LineNumber = Get_LVFocusItem(SD.ListView_hWnd);

            if(LineNumber >= 0)
            {
                char ItemID[64];
                SaveScheduleToDataBase(); // Must do before trying to edit an item
                ListView_GetItemText(SD.ListView_hWnd, LineNumber, 0, ItemID, 64);
                ESD.EditItem = ScheduleIDToPosition( CharInt(ItemID) );

                DialogBox(MainInstance, MAKEINTRESOURCE(105), ScheduleDialog_hWnd, EditScheduleDialog);
            }

			return 0;
   		}

   		if(wParam == 104) // Delete Item Button (Dialog Command)
   		{
   			int LineNumber = Get_LVFocusItem(SD.ListView_hWnd);

            if(LineNumber >= 0)
            {
                if(MessageBox(ScheduleDialog_hWnd, "Are you sure you want to delete this scheduled item?", TitleCaption, MB_YESNO) == IDYES)
                {
                    char ItemID[64];
                    ListView_GetItemText(SD.ListView_hWnd, LineNumber, 0, ItemID, 64);
                    EndScheduleByID(CharInt(ItemID));
                    ListView_DeleteItem(SD.ListView_hWnd, LineNumber);
                    NumberOfSetSchedules--;
                }
            }
			return 0;
   		}

		if(wParam == 100) //- Ok (Dialog Command)
		{
            SaveScheduleToDataBase();
			EndDialog(ScheduleDialog_hWnd, 0);
			return 0;
		}

		return 0;
	}

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        SaveScheduleToDataBase();
        EndDialog(ScheduleDialog_hWnd, 0);
		EndDialog(ScheduleDialog_hWnd, 0);
	}

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

